/*
 *  ESNetscapePluginStream.h
 *  Flash'In'App
 *
 *  Copyright 2008 Eltima Software. All rights reserved.
 *
 *	Flash'In'App is free for non-commercial use.
 *	If you plan to integrate it in commercial software, please, make sure you are acquainted with the license terms and obtain the Commercial License.
 *	Please, contact Eltima at sales@eltima.com or visit http://mac.eltima.com
 */

#ifndef __LP64__

#import <Cocoa/Cocoa.h>
#import "npfunctions.h"

@class ESNetscapePluginView;

@interface ESNetscapePluginStream : NSObject
{
	NSMutableData *deliveryData;
	NSURL *requestURL;
	NSURLRequest *request;
	NSURL *responseURL;
	NSString *MIMEType;
	
  NSURLConnection *connection;

	NPP plugin;
	uint16 transferMode;
	int32 offset;
	NPStream stream;
	char *path;
	BOOL sendNotification;
	void *notifyData;
	char *headers;
	ESNetscapePluginView *pluginView;
	NPReason reason;
	BOOL isTerminated;
			
	NPP_NewStreamProcPtr NPP_NewStream;
	NPP_DestroyStreamProcPtr NPP_DestroyStream;
	NPP_StreamAsFileProcPtr NPP_StreamAsFile;
	NPP_WriteReadyProcPtr NPP_WriteReady;
	NPP_WriteProcPtr NPP_Write;
	NPP_URLNotifyProcPtr NPP_URLNotify;
}

+ (NPReason)reasonForError:(NSError *)error;

- (NSError *)errorForReason:(NPReason)theReason;

- (id)initWithRequest:(NSURLRequest *)theRequest
               plugin:(NPP)thePlugin
           notifyData:(void *)theNotifyData
     sendNotification:(BOOL)flag;

/*
 * set/get requested URL 
 * NOTE: this method is called internally and should not be accessed directly, should you have a requirement to replace the request URL,
 * please, contact us at support@eltima.com for more details
 */
- (void)setRequestURL:(NSURL *)theRequestURL;
- (NSURL *) requestURL;

/*
 * set/get URL from response
 * NOTE: this method is called internally and should not be accessed directly, should you have a requirement to replace the response URL;
 * instead, please, use startStreamWithResponse:, however this will be effective only if netscapeView:shouldLoadRequest:onTarget: 
 * returns StreamLoadType_External
 */
- (void)setResponseURL:(NSURL *)theResponseURL;
- (NSURL *) responseURL;

/*
 * internal use only, should not be publicly accessed
 */
- (void)setPlugin:(NPP)thePlugin;

/*
 * internal use only, should not be publicly accessed
 */
- (uint16)transferMode;
- (NPP)plugin;

/*
 * this will cancel loading any resources with 'error' argument, and destroy the Stream
 * you should call this in case there's an error loading any resource
 */
- (void)cancelLoadAndDestroyStreamWithError:(NSError *)error;

/*
 * start loading data with a certain response (r)
 * Note: is required to initialize Stream object
 */
- (void)startStreamWithResponse:(NSURLResponse *)r;

// destroyStreamWithError tells the plug-in that loading is completed (error == nil) or ended in error.
- (void)destroyStreamWithError:(NSError *)error;

/*
 * pass a portion of data to plugin
 */
- (void)receivedData:(NSData *)data;

/*
 * notify Stream object that data loading is finished (data should be nil here)
 */
- (void)finishedLoadingWithData:(NSData *)data;

/*
 * used for internal loading
 * internal use only, should not be publicly accessed
 */
- (void)start;
- (void)stop;

@end

#endif
